package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 自动收货类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
public enum AutoGoodsType {

    RECEIVE_GOODS("receiveGoods", "收货"),
    CANCEL("cancel", "取消收货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoGoodsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoGoodsType fromCode(String code) {
        return Stream.of(AutoGoodsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
