package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预付款标识
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
public enum PrePaymentIdentification {

    _0("0", "无"),
    _1("1", "小于"),
    _2("2", "等于"),
    _3("3", "大于");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PrePaymentIdentification(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrePaymentIdentification fromCode(String code) {
        return Stream.of(PrePaymentIdentification.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
