package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 采购单操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
public enum PurchaseOrderOperation {

    MODIFY("modify", "运维修改");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurchaseOrderOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseOrderOperation fromCode(String code) {
        return Stream.of(PurchaseOrderOperation.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
