package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 退回方式
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
public enum WithdrawType {

    WITHDRAW_EXPRESS_AND_IMAGE("withdrawExpressAndImage", "退回影像和物流"),
    WITHDRAW_IMAGE("withdrawImage", "仅退回影像");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WithdrawType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WithdrawType fromCode(String code) {
        return Stream.of(WithdrawType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
