package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * goods_receipt_init
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceiptInit implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 主键缺失
   */
  private Boolean isPrimaryKeyAbsent;
  /**
   * 必填项缺失
   */
  private Boolean isRequiredAbsent;
  /**
   * 缺失信息描述
   */
  private String absentMsg;
  /**
   * 本位币金额
   */
  private BigDecimal amount;
  /**
   * 采购单Id
   */
  private Long purchaserOrderAndGoodsReceiptItems;
  /**
   * 采购单明细Id
   */
  private Long purchaseOrderItemAndGoodsReceiptItems;
  /**
   * 采购单号
   */
  private String poNO;
  /**
   * 采购单行号
   */
  private String poLineItemNO;
  /**
   * 物料
   */
  private String materialServices;
  /**
   * 物料描述
   */
  private String materialServicesName;
  /**
   * 按订单单位计的数量
   */
  private BigDecimal quantity;
  /**
   * 收货单号
   */
  private String grNo;
  /**
   * 收货单行号
   */
  private String grItemNo;
  /**
   * 预处理状态
   */
  private String asyncStatus;
  /**
   * 单号和行号
   */
  private String grAndItem;
  /**
   * 预处理次数
   */
  private Long asyncCount;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);
      map.put("amount", amount);
      map.put("purchaserOrderAndGoodsReceiptItems", purchaserOrderAndGoodsReceiptItems);
      map.put("purchaseOrderItemAndGoodsReceiptItems", purchaseOrderItemAndGoodsReceiptItems);
      map.put("poNO", poNO);
      map.put("poLineItemNO", poLineItemNO);
      map.put("materialServices", materialServices);
      map.put("materialServicesName", materialServicesName);
      map.put("quantity", quantity);
      map.put("grNo", grNo);
      map.put("grItemNo", grItemNo);
      map.put("asyncStatus", asyncStatus);
      map.put("grAndItem", grAndItem);
      map.put("asyncCount", asyncCount);

      return map;
  }

  public static GoodsReceiptInit fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceiptInit entity = new GoodsReceiptInit();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserOrderAndGoodsReceiptItems")) {
      Object obj = map.get("purchaserOrderAndGoodsReceiptItems");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserOrderAndGoodsReceiptItems((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserOrderAndGoodsReceiptItems(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserOrderAndGoodsReceiptItems(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderItemAndGoodsReceiptItems")) {
      Object obj = map.get("purchaseOrderItemAndGoodsReceiptItems");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseOrderItemAndGoodsReceiptItems((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseOrderItemAndGoodsReceiptItems(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaseOrderItemAndGoodsReceiptItems(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("poNO")) {
      Object obj = map.get("poNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poLineItemNO")) {
      Object obj = map.get("poLineItemNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoLineItemNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grNo")) {
      Object obj = map.get("grNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grItemNo")) {
      Object obj = map.get("grItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("asyncStatus")) {
      Object obj = map.get("asyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAsyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grAndItem")) {
      Object obj = map.get("grAndItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrAndItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("asyncCount")) {
      Object obj = map.get("asyncCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAsyncCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAsyncCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAsyncCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserOrderAndGoodsReceiptItems")) {
      Object obj = map.get("purchaserOrderAndGoodsReceiptItems");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserOrderAndGoodsReceiptItems((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserOrderAndGoodsReceiptItems(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserOrderAndGoodsReceiptItems(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrderItemAndGoodsReceiptItems")) {
      Object obj = map.get("purchaseOrderItemAndGoodsReceiptItems");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaseOrderItemAndGoodsReceiptItems((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaseOrderItemAndGoodsReceiptItems(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaseOrderItemAndGoodsReceiptItems(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("poNO")) {
      Object obj = map.get("poNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poLineItemNO")) {
      Object obj = map.get("poLineItemNO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoLineItemNO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServices")) {
      Object obj = map.get("materialServices");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServices((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServicesName")) {
      Object obj = map.get("materialServicesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialServicesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grNo")) {
      Object obj = map.get("grNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGrNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grItemNo")) {
      Object obj = map.get("grItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGrItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("asyncStatus")) {
      Object obj = map.get("asyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAsyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grAndItem")) {
      Object obj = map.get("grAndItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGrAndItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("asyncCount")) {
      Object obj = map.get("asyncCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAsyncCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAsyncCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAsyncCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
  }
}
