package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * payment_manage
 * </p>
 *
 * @author ultraman
 * @since 2023-07-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentManage implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 付款申请ID
   */
  private String applyId;
  /**
   * 申请人
   */
  private String applyUserName;
  /**
   * 付款类型
   */
  private String paymentType;
  /**
   * 业务类型
   */
  private String businessType;
  /**
   * 预付款类型
   */
  private String prepaymentType;
  /**
   * 保证金类型
   */
  private String bondType;
  /**
   * 付款对象ID
   */
  private String paymentObjectId;
  /**
   * 付款对象
   */
  private String paymentObject;
  /**
   * 本次申请支付金额
   */
  private BigDecimal applyPaymentAmount;
  /**
   * 本次申请实付金额
   */
  private BigDecimal applyPaidAmount;
  /**
   * 订单总金额
   */
  private BigDecimal orderAmount;
  /**
   * 发票总金额
   */
  private BigDecimal invoiceAmount;
  /**
   * 收款累计
   */
  private BigDecimal collectionAccumulation;
  /**
   * 付款累计
   */
  private BigDecimal paymentAccumulation;
  /**
   * 预付款请求号
   */
  private String prepaymentRequestNo;
  /**
   * 预付核销凭证#限预付单
   */
  private String prepaymentWriteVoucher;
  /**
   * 应付款凭证
   */
  private String paymentVoucher;
  /**
   * 应付款支付凭证
   */
  private String paymentPaymentVoucher;
  /**
   * 应付款清账凭证
   */
  private String paymentClearingVoucher;
  /**
   * 付款状态
   */
  private String currentStatus;
  /**
   * 异常信息
   */
  private String errorInfo;
  /**
   * 利润中心
   */
  private String profitCenter;
  /**
   * 成本中心
   */
  private String costCenter;
  /**
   * 付款人类型
   */
  private String paymentUserType;
  /**
   * 付款到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDueDate;
  /**
   * 付款银行类型
   */
  private String paymentBankType;
  /**
   * 收款银行名称
   */
  private String collectionBank;
  /**
   * 收款银行账号
   */
  private String collectionAccount;
  /**
   * 收款银行户名
   */
  private String collectionName;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 合同名称
   */
  private String contractName;
  /**
   * 合同金额
   */
  private BigDecimal contractAmount;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 起始日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;
  /**
   * 截止日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;
  /**
   * 文本
   */
  private String text;
  /**
   * 付款备注
   */
  private String paymentRemark;
  /**
   * 审批历史
   */
  private String approvalHistory;
  /**
   * 下载者
   */
  private String downloadUserName;
  /**
   * 下载状态
   */
  private String downloadStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 合同签订日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractSignDate;
  /**
   * 开票通知单号
   */
  private String invoiceNoticeNOs;
  /**
   * 当前审批角色
   */
  private String approvalRole;
  /**
   * 执行分公司ID
   */
  private String companyId;
  /**
   * 执行分公司
   */
  private String companyName;
  /**
   * 分公司发票ID
   */
  private String purchaserId;
  /**
   * 发票分公司
   */
  private String purchaserName;
  /**
   * 驳回原因
   */
  private String approvalBody;
  /**
   * agentPaymentTerm
   */
  private String agentPaymentTerm;
  /**
   * 备用金类型
   */
  private String pettyCashType;
  /**
   * 采购组织
   */
  private String purchasingOrg;
  /**
   * 采购组
   */
  private String procurementGroup;
  /**
   * 冻结付款
   */
  private Boolean freezePayment;
  /**
   * 应付款商票凭证
   */
  private String commercialPaymentVoucher;
  /**
   * 换票类型
   */
  private String alterInvoiceIndicator;
  /**
   * 原付款单号
   */
  private String previousApplyId;
  /**
   * 新付款单号
   */
  private String nextApplyId;
  /**
   * 预付款凭证
   */
  private String prepaymentPaymentVoucher;
  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;
  /**
   * 已核销金额#限预付单
   */
  private BigDecimal prepaymentAmount;
  /**
   * 历史已付金额
   */
  private BigDecimal payedAmount;
  /**
   * 保证金金额
   */
  private BigDecimal marginAmount;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 发起角色
   */
  private String initiateRole;
  /**
   * 采购单号
   */
  private String poNos;
  /**
   * 已预付待核销金额#限预付
   */
  private BigDecimal prepaidAmount;
  /**
   * 采购单号lookup
   */
  private String poNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 提交日期	
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitDate;
  /**
   * 记账日期	
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingDate;
  /**
   * 采购单号集合
   */
  private String poNumbers;
  /**
   * 收款银行代码
   */
  private String collectionBankCode;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 数据来源
   */
  private String dataSource;
  /**
   * 自动收货批次号
   */
  private String autoBatchNo;
  /**
   * 自动收货类型
   */
  private String autoGoodsType;
  /**
   * 特殊业务
   */
  private String overPayType;
  /**
   * IRID
   */
  private String irid;

  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
  private Long poAndPrepaymentRelationshipId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("applyId", applyId);
      map.put("applyUserName", applyUserName);
      map.put("paymentType", paymentType);
      map.put("businessType", businessType);
      map.put("prepaymentType", prepaymentType);
      map.put("bondType", bondType);
      map.put("paymentObjectId", paymentObjectId);
      map.put("paymentObject", paymentObject);
      map.put("applyPaymentAmount", applyPaymentAmount);
      map.put("applyPaidAmount", applyPaidAmount);
      map.put("orderAmount", orderAmount);
      map.put("invoiceAmount", invoiceAmount);
      map.put("collectionAccumulation", collectionAccumulation);
      map.put("paymentAccumulation", paymentAccumulation);
      map.put("prepaymentRequestNo", prepaymentRequestNo);
      map.put("prepaymentWriteVoucher", prepaymentWriteVoucher);
      map.put("paymentVoucher", paymentVoucher);
      map.put("paymentPaymentVoucher", paymentPaymentVoucher);
      map.put("paymentClearingVoucher", paymentClearingVoucher);
      map.put("currentStatus", currentStatus);
      map.put("errorInfo", errorInfo);
      map.put("profitCenter", profitCenter);
      map.put("costCenter", costCenter);
      map.put("paymentUserType", paymentUserType);
      map.put("paymentDueDate", BocpGenUtils.toTimestamp(paymentDueDate));
      map.put("paymentBankType", paymentBankType);
      map.put("collectionBank", collectionBank);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionName", collectionName);
      map.put("contractNo", contractNo);
      map.put("contractName", contractName);
      map.put("contractAmount", contractAmount);
      map.put("contractType", contractType);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("text", text);
      map.put("paymentRemark", paymentRemark);
      map.put("approvalHistory", approvalHistory);
      map.put("downloadUserName", downloadUserName);
      map.put("downloadStatus", downloadStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractSignDate", BocpGenUtils.toTimestamp(contractSignDate));
      map.put("invoiceNoticeNOs", invoiceNoticeNOs);
      map.put("approvalRole", approvalRole);
      map.put("companyId", companyId);
      map.put("companyName", companyName);
      map.put("purchaserId", purchaserId);
      map.put("purchaserName", purchaserName);
      map.put("approvalBody", approvalBody);
      map.put("agentPaymentTerm", agentPaymentTerm);
      map.put("pettyCashType", pettyCashType);
      map.put("purchasingOrg", purchasingOrg);
      map.put("procurementGroup", procurementGroup);
      map.put("freezePayment", freezePayment);
      map.put("commercialPaymentVoucher", commercialPaymentVoucher);
      map.put("alterInvoiceIndicator", alterInvoiceIndicator);
      map.put("previousApplyId", previousApplyId);
      map.put("nextApplyId", nextApplyId);
      map.put("prepaymentPaymentVoucher", prepaymentPaymentVoucher);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("prepaymentAmount", prepaymentAmount);
      map.put("payedAmount", payedAmount);
      map.put("marginAmount", marginAmount);
      map.put("projectName", projectName);
      map.put("initiateRole", initiateRole);
      map.put("poNos", poNos);
      map.put("prepaidAmount", prepaidAmount);
      map.put("poNo", poNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("submitDate", BocpGenUtils.toTimestamp(submitDate));
      map.put("accountingDate", BocpGenUtils.toTimestamp(accountingDate));
      map.put("poNumbers", poNumbers);
      map.put("collectionBankCode", collectionBankCode);
      map.put("orderType", orderType);
      map.put("dataSource", dataSource);
      map.put("autoBatchNo", autoBatchNo);
      map.put("autoGoodsType", autoGoodsType);
      map.put("overPayType", overPayType);
      map.put("irid", irid);

      map.put("poAndPrepaymentRelationship.id", poAndPrepaymentRelationshipId);
      return map;
  }

  public static PaymentManage fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    PaymentManage entity = new PaymentManage();

    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentObjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObject")) {
      Object obj = map.get("paymentObject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPaymentAmount")) {
      Object obj = map.get("applyPaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyPaidAmount")) {
      Object obj = map.get("applyPaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccumulation")) {
      Object obj = map.get("collectionAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCollectionAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCollectionAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCollectionAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCollectionAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentAccumulation")) {
      Object obj = map.get("paymentAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentRequestNo")) {
      Object obj = map.get("prepaymentRequestNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucher")) {
      Object obj = map.get("paymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPaymentVoucher")) {
      Object obj = map.get("paymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentClearingVoucher")) {
      Object obj = map.get("paymentClearingVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentClearingVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentUserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDueDate(null);
      }
    }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBank")) {
      Object obj = map.get("collectionBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionName")) {
      Object obj = map.get("collectionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setContractAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRemark")) {
      Object obj = map.get("paymentRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovalHistory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadUserName")) {
      Object obj = map.get("downloadUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDownloadUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDownloadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignDate")) {
      Object obj = map.get("contractSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractSignDate(null);
      }
    }
    if(map.containsKey("invoiceNoticeNOs")) {
      Object obj = map.get("invoiceNoticeNOs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNoticeNOs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalRole")) {
      Object obj = map.get("approvalRole");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovalRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalBody")) {
      Object obj = map.get("approvalBody");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovalBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentPaymentTerm")) {
      Object obj = map.get("agentPaymentTerm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pettyCashType")) {
      Object obj = map.get("pettyCashType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPettyCashType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementGroup")) {
      Object obj = map.get("procurementGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezePayment")) {
      Object obj = map.get("freezePayment");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFreezePayment((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreezePayment(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("commercialPaymentVoucher")) {
      Object obj = map.get("commercialPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommercialPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousApplyId")) {
      Object obj = map.get("previousApplyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreviousApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nextApplyId")) {
      Object obj = map.get("nextApplyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNextApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("prepaymentAmount")) {
      Object obj = map.get("prepaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrepaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("marginAmount")) {
      Object obj = map.get("marginAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMarginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMarginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMarginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMarginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMarginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("initiateRole")) {
      Object obj = map.get("initiateRole");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInitiateRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNos")) {
      Object obj = map.get("poNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitDate(null);
      }
    }
    if(map.containsKey("accountingDate")) {
      Object obj = map.get("accountingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingDate(null);
      }
    }
    if(map.containsKey("poNumbers")) {
      Object obj = map.get("poNumbers");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumbers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBankCode")) {
      Object obj = map.get("collectionBankCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBankCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("autoBatchNo")) {
      Object obj = map.get("autoBatchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("autoGoodsType")) {
      Object obj = map.get("autoGoodsType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoGoodsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("overPayType")) {
      Object obj = map.get("overPayType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOverPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("irid")) {
      Object obj = map.get("irid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIrid((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("poAndPrepaymentRelationship.id")) {
       Object obj = map.get("poAndPrepaymentRelationship.id");
       if(obj instanceof Long) {
         entity.setPoAndPrepaymentRelationshipId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setPoAndPrepaymentRelationshipId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("applyId")) {
      Object obj = map.get("applyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentType")) {
      Object obj = map.get("prepaymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrepaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bondType")) {
      Object obj = map.get("bondType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBondType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObjectId")) {
      Object obj = map.get("paymentObjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentObjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentObject")) {
      Object obj = map.get("paymentObject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyPaymentAmount")) {
      Object obj = map.get("applyPaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyPaidAmount")) {
      Object obj = map.get("applyPaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyPaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyPaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyPaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyPaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyPaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccumulation")) {
      Object obj = map.get("collectionAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCollectionAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCollectionAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCollectionAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCollectionAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCollectionAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentAccumulation")) {
      Object obj = map.get("paymentAccumulation");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaymentAccumulation((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaymentAccumulation(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaymentAccumulation(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentAccumulation(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaymentAccumulation(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentRequestNo")) {
      Object obj = map.get("prepaymentRequestNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrepaymentRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentWriteVoucher")) {
      Object obj = map.get("prepaymentWriteVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrepaymentWriteVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucher")) {
      Object obj = map.get("paymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPaymentVoucher")) {
      Object obj = map.get("paymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentClearingVoucher")) {
      Object obj = map.get("paymentClearingVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentClearingVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentStatus")) {
      Object obj = map.get("currentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorInfo")) {
      Object obj = map.get("errorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profitCenter")) {
      Object obj = map.get("profitCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUserType")) {
      Object obj = map.get("paymentUserType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentUserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDueDate")) {
      Object obj = map.get("paymentDueDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentDueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDueDate(null);
      }
    }
    if(map.containsKey("paymentBankType")) {
      Object obj = map.get("paymentBankType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBank")) {
      Object obj = map.get("collectionBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionName")) {
      Object obj = map.get("collectionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setContractAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setContractAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setContractAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setContractAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setContractAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndDate(null);
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRemark")) {
      Object obj = map.get("paymentRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalHistory")) {
      Object obj = map.get("approvalHistory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApprovalHistory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadUserName")) {
      Object obj = map.get("downloadUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDownloadUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("downloadStatus")) {
      Object obj = map.get("downloadStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDownloadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignDate")) {
      Object obj = map.get("contractSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractSignDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setContractSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractSignDate(null);
      }
    }
    if(map.containsKey("invoiceNoticeNOs")) {
      Object obj = map.get("invoiceNoticeNOs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNoticeNOs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalRole")) {
      Object obj = map.get("approvalRole");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApprovalRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvalBody")) {
      Object obj = map.get("approvalBody");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApprovalBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentPaymentTerm")) {
      Object obj = map.get("agentPaymentTerm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentPaymentTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pettyCashType")) {
      Object obj = map.get("pettyCashType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPettyCashType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingOrg")) {
      Object obj = map.get("purchasingOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasingOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementGroup")) {
      Object obj = map.get("procurementGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezePayment")) {
      Object obj = map.get("freezePayment");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setFreezePayment((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFreezePayment(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("commercialPaymentVoucher")) {
      Object obj = map.get("commercialPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCommercialPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alterInvoiceIndicator")) {
      Object obj = map.get("alterInvoiceIndicator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAlterInvoiceIndicator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousApplyId")) {
      Object obj = map.get("previousApplyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPreviousApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nextApplyId")) {
      Object obj = map.get("nextApplyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNextApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaymentPaymentVoucher")) {
      Object obj = map.get("prepaymentPaymentVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrepaymentPaymentVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("prepaymentAmount")) {
      Object obj = map.get("prepaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrepaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payedAmount")) {
      Object obj = map.get("payedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPayedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPayedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPayedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPayedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("marginAmount")) {
      Object obj = map.get("marginAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMarginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMarginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMarginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMarginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMarginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("initiateRole")) {
      Object obj = map.get("initiateRole");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInitiateRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNos")) {
      Object obj = map.get("poNos");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepaidAmount")) {
      Object obj = map.get("prepaidAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrepaidAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrepaidAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrepaidAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrepaidAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrepaidAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitDate")) {
      Object obj = map.get("submitDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSubmitDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSubmitDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSubmitDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSubmitDate(null);
      }
    }
    if(map.containsKey("accountingDate")) {
      Object obj = map.get("accountingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingDate(null);
      }
    }
    if(map.containsKey("poNumbers")) {
      Object obj = map.get("poNumbers");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNumbers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBankCode")) {
      Object obj = map.get("collectionBankCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionBankCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("autoBatchNo")) {
      Object obj = map.get("autoBatchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("autoGoodsType")) {
      Object obj = map.get("autoGoodsType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAutoGoodsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("overPayType")) {
      Object obj = map.get("overPayType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOverPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("irid")) {
      Object obj = map.get("irid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIrid((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("poAndPrepaymentRelationship.id")) {
    Object obj = map.get("poAndPrepaymentRelationship.id");
    if(obj instanceof Long) {
        this.setPoAndPrepaymentRelationshipId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setPoAndPrepaymentRelationshipId(Long.parseLong((String)obj));
    }
  }
  }
}
