package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_frozen
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum IsFrozen {

    _0("0", "是"),
    _1("1", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsFrozen(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsFrozen fromCode(String code) {
        return Stream.of(IsFrozen.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
