package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * system_label_name
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum SystemLabelName {

    电子发票("电子发票", "电子发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SystemLabelName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemLabelName fromCode(String code) {
        return Stream.of(SystemLabelName.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
