package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * todo_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum TodoType {

    VOUCHER("voucher", "发票校验"),
    MATCH("match", "发票配单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TodoType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TodoType fromCode(String code) {
        return Stream.of(TodoType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
