package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * virtual_po_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-01
 */
public enum VirtualPoType {

    _1("1", "源自无PO预付-诉讼费"),
    _2("2", "直接创建虚拟订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VirtualPoType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VirtualPoType fromCode(String code) {
        return Stream.of(VirtualPoType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
