package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * agency_fee_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum AgencyFeeType {

    _0("0", "默认"),
    _1("1", "标准付款"),
    _2("2", "非标付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AgencyFeeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AgencyFeeType fromCode(String code) {
        return Stream.of(AgencyFeeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
