package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * expense_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum ExpenseType {

    SSF("SSF", "诉讼费"),
    BYJ("BYJ", "备用金"),
    B01("B01", "维保金"),
    B02("B02", "履约保证金"),
    B03("B03", "质量保证金");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExpenseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExpenseType fromCode(String code) {
        return Stream.of(ExpenseType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
