package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_invoice_query_method
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum MatchInvoiceQueryMethod {

    _0("0", "可配单发票"),
    _1("1", "全部发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchInvoiceQueryMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchInvoiceQueryMethod fromCode(String code) {
        return Stream.of(MatchInvoiceQueryMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
