package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * multi_values
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum MultiValues {

    _0("0", "EA4"),
    _1("1", "EA6"),
    _2("2", "EA8");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MultiValues(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MultiValues fromCode(String code) {
        return Stream.of(MultiValues.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
