package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * payment_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum PaymentType {

    _1("1", "应付款"),
    _2("2", "预付款"),
    _3("3", "逆向应付款"),
    _4("4", "逆向预付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentType fromCode(String code) {
        return Stream.of(PaymentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
