package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * produce_obj
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum ProduceObj {

    PURCHASE_ORDER("PURCHASE_ORDER", "采购单待办"),
    RECEIVE_ORDER("RECEIVE_ORDER", "收货单待办"),
    NOTICE_ORDER("NOTICE_ORDER", "开票通知单待办");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProduceObj(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceObj fromCode(String code) {
        return Stream.of(ProduceObj.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
