package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * resqust_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum ResqustStatus {

    _0("0", "待处理"),
    _1("1", "已完成"),
    _2("2", "已取消"),
    _3("3", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ResqustStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ResqustStatus fromCode(String code) {
        return Stream.of(ResqustStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
