package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * role_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public enum RoleType {

    A0001("A0001", "申请人"),
    A002("A002", "分公司部门经理"),
    A003("A003", "分公司总经理（BGM）"),
    A004("A004", "区域总经理（RGM）"),
    A005("A005", "首席财务官（CFO）"),
    A006("A006", "总部财务（预付）"),
    A007("A007", "总部财务（应付）"),
    A100("A100", "供应商"),
    A008("A008", "BUAP/tkEAG/tkAG"),
    A009("A009", "区域财务（RFC）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RoleType fromCode(String code) {
        return Stream.of(RoleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
