package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * agent_fee_report_init_failed_history
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AgentFeeReportInitFailedHistory implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 业务线
   */
  private String loB;
  /**
   * 销售区域
   */
  private String salesRegion;
  /**
   * 执行区域
   */
  private String executionRegion;
  /**
   * 项目中文名称
   */
  private String projectNameZh;
  /**
   * 项目英文名称
   */
  private String projectNameEn;
  /**
   * 销售渠道
   */
  private String salesChannel;
  /**
   * 销售分公司
   */
  private String salesBranchEn;
  /**
   * 执行分公司
   */
  private String executionBranchEn;
  /**
   * 跨分公司项目标记
   */
  private String ifCrossBranchProject;
  /**
   * 首次OI时间
   */
  private String firstOIDate;
  /**
   * 销售分公司VIEW项目号
   */
  private String salesBranchVIEWProjectId;
  /**
   * 执行分公司VIEW项目号
   */
  private String executionBranchVIEWProjectId;
  /**
   * Daproh项目编码
   */
  private String daprohProjectId;
  /**
   * Daproh系统的VIEW项目编码
   */
  private String daprohVIEWProjectId;
  /**
   * 项目状态
   */
  private String projectStatus;
  /**
   * 代理商名称
   */
  private String agentSupplierName;
  /**
   * 代理商GMDS编码
   */
  private String agentSupplierGMDSNo;
  /**
   * 项目设备合同额(排除VO)
   */
  private String projectEquipmentContractValue;
  /**
   * 项目设备收款额(排除VO)
   */
  private String totalProjectCollectedMoney;
  /**
   * 项目设备收款比例
   */
  private String collectionPercent;
  /**
   * VO合同金额
   */
  private String contractAmountVo;
  /**
   * VO收款金额
   */
  private String collectionAmountVo;
  /**
   * VO收款比例
   */
  private String collectionPercentVo;
  /**
   * 代理费采购订单编码
   */
  private String agentFeePoNumber;
  /**
   * 代理费采购订单金额
   */
  private String totalAgentFeePoAmount;
  /**
   * 代理费累计可支付代理商金额
   */
  private String totalAccumulativePayableAgentFee;
  /**
   * PO状态
   */
  private String poStatus;
  /**
   * 代理费累计收货金额
   */
  private String totalAgentFeeGRAmount;
  /**
   * 代理费累计发票校验金额
   */
  private String totalVerifiedAgentFeeInvoiceAmountIR;
  /**
   * 代理费最后一次开票日期
   */
  private String agentFeeLastInvoiceDate;
  /**
   * 代理费收货和发票的一致性检查
   */
  private String agentFeeInvoiceGrCheck;
  /**
   * 代理商发票开具进度
   */
  private String invoiceStatus;
  /**
   * light
   */
  private String light;
  /**
   * 代理费含税采购订单金额
   */
  private String agentFeePoAmountWithTax;
  /**
   * 代理费含税的收货金额
   */
  private String agentFeeTotalGRAmountWithTax;
  /**
   * 含税累计可支付代理商金额
   */
  private String totalAccumulativePayableAgentFeeWithTax;
  /**
   * 含税发票校验金额
   */
  private String totalVerifiedInvoiceAmountIrWithTax;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 主键缺失
   */
  private Boolean isPrimaryKeyAbsent;
  /**
   * 必填项缺失
   */
  private Boolean isRequiredAbsent;
  /**
   * 缺失信息描述
   */
  private String absentMsg;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("loB", loB);
      map.put("salesRegion", salesRegion);
      map.put("executionRegion", executionRegion);
      map.put("projectNameZh", projectNameZh);
      map.put("projectNameEn", projectNameEn);
      map.put("salesChannel", salesChannel);
      map.put("salesBranchEn", salesBranchEn);
      map.put("executionBranchEn", executionBranchEn);
      map.put("ifCrossBranchProject", ifCrossBranchProject);
      map.put("firstOIDate", firstOIDate);
      map.put("salesBranchVIEWProjectId", salesBranchVIEWProjectId);
      map.put("executionBranchVIEWProjectId", executionBranchVIEWProjectId);
      map.put("daprohProjectId", daprohProjectId);
      map.put("daprohVIEWProjectId", daprohVIEWProjectId);
      map.put("projectStatus", projectStatus);
      map.put("agentSupplierName", agentSupplierName);
      map.put("agentSupplierGMDSNo", agentSupplierGMDSNo);
      map.put("projectEquipmentContractValue", projectEquipmentContractValue);
      map.put("totalProjectCollectedMoney", totalProjectCollectedMoney);
      map.put("collectionPercent", collectionPercent);
      map.put("contractAmountVo", contractAmountVo);
      map.put("collectionAmountVo", collectionAmountVo);
      map.put("collectionPercentVo", collectionPercentVo);
      map.put("agentFeePoNumber", agentFeePoNumber);
      map.put("totalAgentFeePoAmount", totalAgentFeePoAmount);
      map.put("totalAccumulativePayableAgentFee", totalAccumulativePayableAgentFee);
      map.put("poStatus", poStatus);
      map.put("totalAgentFeeGRAmount", totalAgentFeeGRAmount);
      map.put("totalVerifiedAgentFeeInvoiceAmountIR", totalVerifiedAgentFeeInvoiceAmountIR);
      map.put("agentFeeLastInvoiceDate", agentFeeLastInvoiceDate);
      map.put("agentFeeInvoiceGrCheck", agentFeeInvoiceGrCheck);
      map.put("invoiceStatus", invoiceStatus);
      map.put("light", light);
      map.put("agentFeePoAmountWithTax", agentFeePoAmountWithTax);
      map.put("agentFeeTotalGRAmountWithTax", agentFeeTotalGRAmountWithTax);
      map.put("totalAccumulativePayableAgentFeeWithTax", totalAccumulativePayableAgentFeeWithTax);
      map.put("totalVerifiedInvoiceAmountIrWithTax", totalVerifiedInvoiceAmountIrWithTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("isPrimaryKeyAbsent", isPrimaryKeyAbsent);
      map.put("isRequiredAbsent", isRequiredAbsent);
      map.put("absentMsg", absentMsg);

      return map;
  }

  public static AgentFeeReportInitFailedHistory fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    AgentFeeReportInitFailedHistory entity = new AgentFeeReportInitFailedHistory();

    if(map.containsKey("loB")) {
      Object obj = map.get("loB");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLoB((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesRegion")) {
      Object obj = map.get("salesRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionRegion")) {
      Object obj = map.get("executionRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExecutionRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameZh")) {
      Object obj = map.get("projectNameZh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectNameZh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameEn")) {
      Object obj = map.get("projectNameEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectNameEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesChannel")) {
      Object obj = map.get("salesChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchEn")) {
      Object obj = map.get("salesBranchEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchEn")) {
      Object obj = map.get("executionBranchEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExecutionBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifCrossBranchProject")) {
      Object obj = map.get("ifCrossBranchProject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfCrossBranchProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstOIDate")) {
      Object obj = map.get("firstOIDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstOIDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchVIEWProjectId")) {
      Object obj = map.get("salesBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchVIEWProjectId")) {
      Object obj = map.get("executionBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExecutionBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohProjectId")) {
      Object obj = map.get("daprohProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDaprohProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohVIEWProjectId")) {
      Object obj = map.get("daprohVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDaprohVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStatus")) {
      Object obj = map.get("projectStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierName")) {
      Object obj = map.get("agentSupplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierGMDSNo")) {
      Object obj = map.get("agentSupplierGMDSNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentSupplierGMDSNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectEquipmentContractValue")) {
      Object obj = map.get("projectEquipmentContractValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectEquipmentContractValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalProjectCollectedMoney")) {
      Object obj = map.get("totalProjectCollectedMoney");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalProjectCollectedMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercent")) {
      Object obj = map.get("collectionPercent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionPercent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmountVo")) {
      Object obj = map.get("contractAmountVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAmountVo")) {
      Object obj = map.get("collectionAmountVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercentVo")) {
      Object obj = map.get("collectionPercentVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionPercentVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoNumber")) {
      Object obj = map.get("agentFeePoNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentFeePoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeePoAmount")) {
      Object obj = map.get("totalAgentFeePoAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalAgentFeePoAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFee")) {
      Object obj = map.get("totalAccumulativePayableAgentFee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalAccumulativePayableAgentFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poStatus")) {
      Object obj = map.get("poStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeeGRAmount")) {
      Object obj = map.get("totalAgentFeeGRAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalAgentFeeGRAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedAgentFeeInvoiceAmountIR")) {
      Object obj = map.get("totalVerifiedAgentFeeInvoiceAmountIR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalVerifiedAgentFeeInvoiceAmountIR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeLastInvoiceDate")) {
      Object obj = map.get("agentFeeLastInvoiceDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentFeeLastInvoiceDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeInvoiceGrCheck")) {
      Object obj = map.get("agentFeeInvoiceGrCheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentFeeInvoiceGrCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("light")) {
      Object obj = map.get("light");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoAmountWithTax")) {
      Object obj = map.get("agentFeePoAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentFeePoAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeTotalGRAmountWithTax")) {
      Object obj = map.get("agentFeeTotalGRAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentFeeTotalGRAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFeeWithTax")) {
      Object obj = map.get("totalAccumulativePayableAgentFeeWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalAccumulativePayableAgentFeeWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedInvoiceAmountIrWithTax")) {
      Object obj = map.get("totalVerifiedInvoiceAmountIrWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalVerifiedInvoiceAmountIrWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbsentMsg((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("loB")) {
      Object obj = map.get("loB");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLoB((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesRegion")) {
      Object obj = map.get("salesRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionRegion")) {
      Object obj = map.get("executionRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExecutionRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameZh")) {
      Object obj = map.get("projectNameZh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectNameZh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNameEn")) {
      Object obj = map.get("projectNameEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectNameEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesChannel")) {
      Object obj = map.get("salesChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchEn")) {
      Object obj = map.get("salesBranchEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchEn")) {
      Object obj = map.get("executionBranchEn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExecutionBranchEn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifCrossBranchProject")) {
      Object obj = map.get("ifCrossBranchProject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIfCrossBranchProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstOIDate")) {
      Object obj = map.get("firstOIDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstOIDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBranchVIEWProjectId")) {
      Object obj = map.get("salesBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("executionBranchVIEWProjectId")) {
      Object obj = map.get("executionBranchVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExecutionBranchVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohProjectId")) {
      Object obj = map.get("daprohProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDaprohProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("daprohVIEWProjectId")) {
      Object obj = map.get("daprohVIEWProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDaprohVIEWProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStatus")) {
      Object obj = map.get("projectStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierName")) {
      Object obj = map.get("agentSupplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentSupplierGMDSNo")) {
      Object obj = map.get("agentSupplierGMDSNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentSupplierGMDSNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectEquipmentContractValue")) {
      Object obj = map.get("projectEquipmentContractValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectEquipmentContractValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalProjectCollectedMoney")) {
      Object obj = map.get("totalProjectCollectedMoney");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalProjectCollectedMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercent")) {
      Object obj = map.get("collectionPercent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionPercent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmountVo")) {
      Object obj = map.get("contractAmountVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAmountVo")) {
      Object obj = map.get("collectionAmountVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAmountVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionPercentVo")) {
      Object obj = map.get("collectionPercentVo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionPercentVo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoNumber")) {
      Object obj = map.get("agentFeePoNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentFeePoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeePoAmount")) {
      Object obj = map.get("totalAgentFeePoAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalAgentFeePoAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFee")) {
      Object obj = map.get("totalAccumulativePayableAgentFee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalAccumulativePayableAgentFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poStatus")) {
      Object obj = map.get("poStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAgentFeeGRAmount")) {
      Object obj = map.get("totalAgentFeeGRAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalAgentFeeGRAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedAgentFeeInvoiceAmountIR")) {
      Object obj = map.get("totalVerifiedAgentFeeInvoiceAmountIR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalVerifiedAgentFeeInvoiceAmountIR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeLastInvoiceDate")) {
      Object obj = map.get("agentFeeLastInvoiceDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentFeeLastInvoiceDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeInvoiceGrCheck")) {
      Object obj = map.get("agentFeeInvoiceGrCheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentFeeInvoiceGrCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("light")) {
      Object obj = map.get("light");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeePoAmountWithTax")) {
      Object obj = map.get("agentFeePoAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentFeePoAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentFeeTotalGRAmountWithTax")) {
      Object obj = map.get("agentFeeTotalGRAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentFeeTotalGRAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAccumulativePayableAgentFeeWithTax")) {
      Object obj = map.get("totalAccumulativePayableAgentFeeWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalAccumulativePayableAgentFeeWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalVerifiedInvoiceAmountIrWithTax")) {
      Object obj = map.get("totalVerifiedInvoiceAmountIrWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTotalVerifiedInvoiceAmountIrWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isPrimaryKeyAbsent")) {
      Object obj = map.get("isPrimaryKeyAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsPrimaryKeyAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsPrimaryKeyAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isRequiredAbsent")) {
      Object obj = map.get("isRequiredAbsent");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsRequiredAbsent((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsRequiredAbsent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("absentMsg")) {
      Object obj = map.get("absentMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbsentMsg((String)obj);
        }
      } else{
      }
    }
  }
}
