package com.xforceplus.ultraman.app.jctke.metadata.validator;

import com.xforceplus.ultraman.app.jctke.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jctke.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-19
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(PoStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PoStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PoStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaseOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaseOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaseOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(PrepaymentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PrepaymentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PrepaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(ENumReceiptType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ENumReceiptType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ENumReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApprovalStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApprovalStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApprovalStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpenseType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExpenseType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExpenseType.class.getSimpleName());
            }
        }
        if(clazz.equals(RoleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RoleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RoleType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResqustStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ResqustStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ResqustStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(LedgerType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LedgerType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LedgerType.class.getSimpleName());
            }
        }
        if(clazz.equals(PrePaymentIdentification.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PrePaymentIdentification.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PrePaymentIdentification.class.getSimpleName());
            }
        }
        if(clazz.equals(IsFrozen.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsFrozen.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsFrozen.class.getSimpleName());
            }
        }
        if(clazz.equals(AgencyFeeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AgencyFeeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AgencyFeeType.class.getSimpleName());
            }
        }
        if(clazz.equals(BondType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BondType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BondType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangeTicketType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChangeTicketType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChangeTicketType.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CurrentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentUserType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentUserType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentUserType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentBankType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentBankType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentBankType.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ContractType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ContractType.class.getSimpleName());
            }
        }
        if(clazz.equals(DownloadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DownloadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DownloadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceNoticeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceNoticeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceNoticeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErrorCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceNoticeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceNoticeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceNoticeType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRegisterStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceRegisterStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceRegisterStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TrueStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TrueStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TrueStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ScanStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ScanStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaResponseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RpaResponseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RpaResponseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VirtualPoType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VirtualPoType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VirtualPoType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(SucceedOrError.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SucceedOrError.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SucceedOrError.class.getSimpleName());
            }
        }
        if(clazz.equals(MultiValues.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MultiValues.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MultiValues.class.getSimpleName());
            }
        }
        if(clazz.equals(PettyCashType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PettyCashType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PettyCashType.class.getSimpleName());
            }
        }
        if(clazz.equals(PostStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PostStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PostStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOperation.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceOperation.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceOperation.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoToEn.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoToEn.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoToEn.class.getSimpleName());
            }
        }
        if(clazz.equals(EventType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EventType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EventType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesOrNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(CodeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CodeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CodeType.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnaphostFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailSendScene.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EmailSendScene.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EmailSendScene.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnaphostFormatZnHUx9ie3DZpRo5T2c6zpK.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatusIYpahCP6HYtYaCemDzEJJR.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatusIYpahCP6HYtYaCemDzEJJR.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatusIYpahCP6HYtYaCemDzEJJR.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountLeftBorderSymbol.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AmountLeftBorderSymbol.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AmountLeftBorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountRightBorderSymbol.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AmountRightBorderSymbol.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AmountRightBorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(AsyncStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AsyncStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AsyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RpaStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RpaStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RpaStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EamilProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EamilProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EamilProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceObj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceObj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceObj.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProduceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProduceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProduceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoGoodsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoGoodsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BorderSymbol.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BorderSymbol.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BorderSymbol.class.getSimpleName());
            }
        }
        if(clazz.equals(WithdrawType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WithdrawType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WithdrawType.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchInvoiceQueryMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchInvoiceQueryMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchInvoiceQueryMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(Removed.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Removed.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Removed.class.getSimpleName());
            }
        }
        if(clazz.equals(OverPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OverPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OverPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(EntityCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EntityCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EntityCode.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaseOrderOperation.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaseOrderOperation.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaseOrderOperation.class.getSimpleName());
            }
        }
        if(clazz.equals(MarkType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MarkType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MarkType.class.getSimpleName());
            }
        }
        if(clazz.equals(PlanStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PlanStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PlanStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemLabelName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemLabelName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemLabelName.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TodoType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TodoType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TodoType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
