package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_notice_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum InvoiceNoticeStatus {

    _0("0", "待生成"),
    _1("1", "生成中"),
    _2("2", "已生成"),
    _3("3", "部分生成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceNoticeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceNoticeStatus fromCode(String code) {
        return Stream.of(InvoiceNoticeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
