package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum InvoiceStatus {

    _0("0", "待配单"),
    _1("1", "已配单"),
    _2("2", "已寄送"),
    _3("3", "已签核"),
    _4("4", "已退回"),
    _5("5", "已记账"),
    _6("6", "已支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code) {
        return Stream.of(InvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
