package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_to_en
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum NoToEn {

    _0("0", " "),
    _1("1", "A"),
    _2("2", "B"),
    _3("3", "C"),
    _4("4", "D"),
    _5("5", "E"),
    _6("6", "F"),
    _7("7", "G"),
    _8("8", "H"),
    _9("9", "I"),
    _10("10", "J"),
    _11("11", "K"),
    _12("12", "L"),
    _13("13", "M"),
    _14("14", "N"),
    _15("15", "O"),
    _16("16", "P"),
    _17("17", "Q"),
    _18("18", "R"),
    _19("19", "S"),
    _20("20", "T"),
    _21("21", "U"),
    _22("22", "V"),
    _23("23", "W"),
    _24("24", "X"),
    _25("25", "Y"),
    _26("26", "Z");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoToEn(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoToEn fromCode(String code) {
        return Stream.of(NoToEn.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
