package com.xforceplus.ultraman.app.jctke.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * succeed_or_error
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum SucceedOrError {

    __1("-1", "失败"),
    _1("1", "成功"),
    _0("0", "默认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SucceedOrError(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SucceedOrError fromCode(String code) {
        return Stream.of(SucceedOrError.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
