package com.xforceplus.ultraman.app.jctke.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * accounts_payable_interface
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountsPayableInterface implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 付款单号
   */
  private String paymentNo;
  /**
   * 付款类型
   */
  private String paymentType;
  /**
   * 预付款标识
   */
  private String prePaymentIdentification;
  /**
   * 预付款凭证号
   */
  private String prePaymentVoucherNo;
  /**
   * 预付款本次核销金额
   */
  private BigDecimal prePaymentAmount;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票金额
   */
  private BigDecimal amountWithTax;
  /**
   * 发票税额
   */
  private BigDecimal taxAmount;
  /**
   * PO列表
   */
  private String poList;
  /**
   * 是否需要冻结
   */
  private String isFrozen;
  /**
   * 应付款凭证号
   */
  private String paymentVoucherNo;
  /**
   * 逆向单凭证号
   */
  private String reverseOrderVoucherNo;
  /**
   * 预付款清账凭证
   */
  private String prePayment;
  /**
   * 应付款凭证号(607)
   */
  private String paymentVoucherNoTwo;
  /**
   * 清账凭证号(15)
   */
  private String settleAccountsVoucherNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 推送RPA任务号
   */
  private String rpaTaskId;
  /**
   * 入库时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime warehousingTime;
  /**
   * 付款单id
   */
  private Long payMentId;

  /**
   * 对一关联关系 关联对象 paymentManage
   */
  private Long accountsPayableInterfaceRelationId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("paymentNo", paymentNo);
      map.put("paymentType", paymentType);
      map.put("prePaymentIdentification", prePaymentIdentification);
      map.put("prePaymentVoucherNo", prePaymentVoucherNo);
      map.put("prePaymentAmount", prePaymentAmount);
      map.put("paperDrewDate", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("invoiceNo", invoiceNo);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("poList", poList);
      map.put("isFrozen", isFrozen);
      map.put("paymentVoucherNo", paymentVoucherNo);
      map.put("reverseOrderVoucherNo", reverseOrderVoucherNo);
      map.put("prePayment", prePayment);
      map.put("paymentVoucherNoTwo", paymentVoucherNoTwo);
      map.put("settleAccountsVoucherNo", settleAccountsVoucherNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rpaTaskId", rpaTaskId);
      map.put("warehousingTime", BocpGenUtils.toTimestamp(warehousingTime));
      map.put("payMentId", payMentId);

      map.put("accountsPayableInterfaceRelation.id", accountsPayableInterfaceRelationId);
      return map;
  }

  public static AccountsPayableInterface fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountsPayableInterface entity = new AccountsPayableInterface();

    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentIdentification")) {
      Object obj = map.get("prePaymentIdentification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrePaymentIdentification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentVoucherNo")) {
      Object obj = map.get("prePaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrePaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentAmount")) {
      Object obj = map.get("prePaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrePaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrePaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrePaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrePaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrePaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poList")) {
      Object obj = map.get("poList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isFrozen")) {
      Object obj = map.get("isFrozen");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsFrozen((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseOrderVoucherNo")) {
      Object obj = map.get("reverseOrderVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseOrderVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrePayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNoTwo")) {
      Object obj = map.get("paymentVoucherNoTwo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentVoucherNoTwo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAccountsVoucherNo")) {
      Object obj = map.get("settleAccountsVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettleAccountsVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rpaTaskId")) {
      Object obj = map.get("rpaTaskId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRpaTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehousingTime")) {
      Object obj = map.get("warehousingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setWarehousingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWarehousingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWarehousingTime(null);
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayMentId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("accountsPayableInterfaceRelation.id")) {
       Object obj = map.get("accountsPayableInterfaceRelation.id");
       if(obj instanceof Long) {
         entity.setAccountsPayableInterfaceRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setAccountsPayableInterfaceRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentIdentification")) {
      Object obj = map.get("prePaymentIdentification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrePaymentIdentification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentVoucherNo")) {
      Object obj = map.get("prePaymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrePaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePaymentAmount")) {
      Object obj = map.get("prePaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrePaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrePaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrePaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrePaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrePaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poList")) {
      Object obj = map.get("poList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isFrozen")) {
      Object obj = map.get("isFrozen");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsFrozen((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNo")) {
      Object obj = map.get("paymentVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseOrderVoucherNo")) {
      Object obj = map.get("reverseOrderVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReverseOrderVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prePayment")) {
      Object obj = map.get("prePayment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrePayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVoucherNoTwo")) {
      Object obj = map.get("paymentVoucherNoTwo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentVoucherNoTwo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAccountsVoucherNo")) {
      Object obj = map.get("settleAccountsVoucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettleAccountsVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rpaTaskId")) {
      Object obj = map.get("rpaTaskId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRpaTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehousingTime")) {
      Object obj = map.get("warehousingTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setWarehousingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setWarehousingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWarehousingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setWarehousingTime(null);
      }
    }
    if(map.containsKey("payMentId")) {
      Object obj = map.get("payMentId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPayMentId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayMentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPayMentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
  if(map.containsKey("accountsPayableInterfaceRelation.id")) {
    Object obj = map.get("accountsPayableInterfaceRelation.id");
    if(obj instanceof Long) {
        this.setAccountsPayableInterfaceRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setAccountsPayableInterfaceRelationId(Long.parseLong((String)obj));
    }
  }
  }
}
