package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PoGrabTask;
import com.xforceplus.ultraman.app.jctke.service.IPoGrabTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 采购单凭证号抓取任务前端控制器
 *
 * @author ultraman
 * @date 2022-03-16
 */
@RestController
public class PoGrabTaskController {

  @Autowired
  private IPoGrabTaskService poGrabTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param poGrabTask 采购单凭证号抓取任务
   * @return
   */
  @GetMapping("/pograbtasks" )
  public XfR getPoGrabTasks(XfPage page, PoGrabTask poGrabTask) {
    return XfR.ok(poGrabTaskServiceImpl.page(page, Wrappers.query(poGrabTask)));
  }

  /**
   * 通过id查询采购单凭证号抓取任务
   * @param  id
   * @return XfR
   */
  @GetMapping("/pograbtasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(poGrabTaskServiceImpl.getById(id));
  }

  /**
   * 新增采购单凭证号抓取任务
   * @param poGrabTask 采购单凭证号抓取任务
   * @return XfR
   */
  @PostMapping("/pograbtasks")
  public XfR save(@RequestBody PoGrabTask poGrabTask) {
     return XfR.ok(poGrabTaskServiceImpl.save(poGrabTask));
  }

  /**
   * 修改-传入修改后的全部数据采购单凭证号抓取任务
   * @param poGrabTask 采购单凭证号抓取任务
   * @return XfR
   */
  @PutMapping("/pograbtasks/{id}")
  public XfR putUpdate(@RequestBody PoGrabTask poGrabTask,@PathVariable Long id) {
      poGrabTask.setId(id);
      return XfR.ok(poGrabTaskServiceImpl.updateById(poGrabTask));
  }

  /**
   * 修改-传入修改的数据采购单凭证号抓取任务
   * @param poGrabTask 采购单凭证号抓取任务
   * @return XfR
   */
  @PatchMapping("/pograbtasks/{id}")
  public XfR patchUpdate(@RequestBody PoGrabTask poGrabTask,@PathVariable Long id) {
      PoGrabTask uppoGrabTask = poGrabTaskServiceImpl.getById(id);
      if(uppoGrabTask != null){
        uppoGrabTask = ObjectCopyUtils.copyProperties(poGrabTask,uppoGrabTask,true);
      }
      return XfR.ok(poGrabTaskServiceImpl.updateById(uppoGrabTask));
  }

  /**
   * 通过id删除采购单凭证号抓取任务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pograbtasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(poGrabTaskServiceImpl.removeById(id));
  }

  @PostMapping("/pograbtasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "po_grab_task");
     params.put("request", condition);

     return XfR.ok(poGrabTaskServiceImpl.querys(params));
  }

}
