package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.CostCenter;
import com.xforceplus.ultraman.app.jctke.service.ICostCenterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-18
 */
@RestController
public class CostCenterController {

  @Autowired
  private ICostCenterService costCenterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param costCenter ${table.comment}
   * @return
   */
  @GetMapping("/costcenters" )
  public XfR getCostCenters(XfPage page, CostCenter costCenter) {
    return XfR.ok(costCenterServiceImpl.page(page, Wrappers.query(costCenter)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/costcenters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costCenterServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param costCenter ${table.comment}
   * @return XfR
   */
  @PostMapping("/costcenters")
  public XfR save(@RequestBody CostCenter costCenter) {
     return XfR.ok(costCenterServiceImpl.save(costCenter));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param costCenter ${table.comment}
   * @return XfR
   */
  @PutMapping("/costcenters/{id}")
  public XfR putUpdate(@RequestBody CostCenter costCenter,@PathVariable Long id) {
      costCenter.setId(id);
      return XfR.ok(costCenterServiceImpl.updateById(costCenter));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param costCenter ${table.comment}
   * @return XfR
   */
  @PatchMapping("/costcenters/{id}")
  public XfR patchUpdate(@RequestBody CostCenter costCenter,@PathVariable Long id) {
      CostCenter upcostCenter = costCenterServiceImpl.getById(id);
      if(upcostCenter != null){
        upcostCenter = ObjectCopyUtils.copyProperties(costCenter,upcostCenter,true);
      }
      return XfR.ok(costCenterServiceImpl.updateById(upcostCenter));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costcenters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costCenterServiceImpl.removeById(id));
  }

  @PostMapping("/costcenters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cost_center");
     params.put("request", condition);

     return XfR.ok(costCenterServiceImpl.querys(params));
  }

}
