package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.GoodsReceiptItem;
import com.xforceplus.ultraman.app.jctke.service.IGoodsReceiptItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 收货单明细前端控制器
 *
 * @author ultraman
 * @date 2022-04-18
 */
@RestController
public class GoodsReceiptItemController {

  @Autowired
  private IGoodsReceiptItemService goodsReceiptItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceiptItem 收货单明细
   * @return
   */
  @GetMapping("/goodsreceiptitems" )
  public XfR getGoodsReceiptItems(XfPage page, GoodsReceiptItem goodsReceiptItem) {
    return XfR.ok(goodsReceiptItemServiceImpl.page(page, Wrappers.query(goodsReceiptItem)));
  }

  /**
   * 通过id查询收货单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceiptitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptItemServiceImpl.getById(id));
  }

  /**
   * 新增收货单明细
   * @param goodsReceiptItem 收货单明细
   * @return XfR
   */
  @PostMapping("/goodsreceiptitems")
  public XfR save(@RequestBody GoodsReceiptItem goodsReceiptItem) {
     return XfR.ok(goodsReceiptItemServiceImpl.save(goodsReceiptItem));
  }

  /**
   * 修改-传入修改后的全部数据收货单明细
   * @param goodsReceiptItem 收货单明细
   * @return XfR
   */
  @PutMapping("/goodsreceiptitems/{id}")
  public XfR putUpdate(@RequestBody GoodsReceiptItem goodsReceiptItem,@PathVariable Long id) {
      goodsReceiptItem.setId(id);
      return XfR.ok(goodsReceiptItemServiceImpl.updateById(goodsReceiptItem));
  }

  /**
   * 修改-传入修改的数据收货单明细
   * @param goodsReceiptItem 收货单明细
   * @return XfR
   */
  @PatchMapping("/goodsreceiptitems/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceiptItem goodsReceiptItem,@PathVariable Long id) {
      GoodsReceiptItem upgoodsReceiptItem = goodsReceiptItemServiceImpl.getById(id);
      if(upgoodsReceiptItem != null){
        upgoodsReceiptItem = ObjectCopyUtils.copyProperties(goodsReceiptItem,upgoodsReceiptItem,true);
      }
      return XfR.ok(goodsReceiptItemServiceImpl.updateById(upgoodsReceiptItem));
  }

  /**
   * 通过id删除收货单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceiptitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptItemServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceiptitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_receipt_item");
     params.put("request", condition);

     return XfR.ok(goodsReceiptItemServiceImpl.querys(params));
  }

}
