package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.InvoiceNoticeBill;
import com.xforceplus.ultraman.app.jctke.service.IInvoiceNoticeBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-18
 */
@RestController
public class InvoiceNoticeBillController {

  @Autowired
  private IInvoiceNoticeBillService invoiceNoticeBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceNoticeBill ${table.comment}
   * @return
   */
  @GetMapping("/invoicenoticebills" )
  public XfR getInvoiceNoticeBills(XfPage page, InvoiceNoticeBill invoiceNoticeBill) {
    return XfR.ok(invoiceNoticeBillServiceImpl.page(page, Wrappers.query(invoiceNoticeBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicenoticebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceNoticeBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicenoticebills")
  public XfR save(@RequestBody InvoiceNoticeBill invoiceNoticeBill) {
     return XfR.ok(invoiceNoticeBillServiceImpl.save(invoiceNoticeBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceNoticeBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicenoticebills/{id}")
  public XfR putUpdate(@RequestBody InvoiceNoticeBill invoiceNoticeBill,@PathVariable Long id) {
      invoiceNoticeBill.setId(id);
      return XfR.ok(invoiceNoticeBillServiceImpl.updateById(invoiceNoticeBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceNoticeBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicenoticebills/{id}")
  public XfR patchUpdate(@RequestBody InvoiceNoticeBill invoiceNoticeBill,@PathVariable Long id) {
      InvoiceNoticeBill upinvoiceNoticeBill = invoiceNoticeBillServiceImpl.getById(id);
      if(upinvoiceNoticeBill != null){
        upinvoiceNoticeBill = ObjectCopyUtils.copyProperties(invoiceNoticeBill,upinvoiceNoticeBill,true);
      }
      return XfR.ok(invoiceNoticeBillServiceImpl.updateById(upinvoiceNoticeBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicenoticebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceNoticeBillServiceImpl.removeById(id));
  }

  @PostMapping("/invoicenoticebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_notice_bill");
     params.put("request", condition);

     return XfR.ok(invoiceNoticeBillServiceImpl.querys(params));
  }

}
