package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PurchaseOrderItem;
import com.xforceplus.ultraman.app.jctke.service.IPurchaseOrderItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 采购订单明细信息前端控制器
 *
 * @author ultraman
 * @date 2022-04-27
 */
@RestController
public class PurchaseOrderItemController {

  @Autowired
  private IPurchaseOrderItemService purchaseOrderItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrderItem 采购订单明细信息
   * @return
   */
  @GetMapping("/purchaseorderitems" )
  public XfR getPurchaseOrderItems(XfPage page, PurchaseOrderItem purchaseOrderItem) {
    return XfR.ok(purchaseOrderItemServiceImpl.page(page, Wrappers.query(purchaseOrderItem)));
  }

  /**
   * 通过id查询采购订单明细信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorderitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderItemServiceImpl.getById(id));
  }

  /**
   * 新增采购订单明细信息
   * @param purchaseOrderItem 采购订单明细信息
   * @return XfR
   */
  @PostMapping("/purchaseorderitems")
  public XfR save(@RequestBody PurchaseOrderItem purchaseOrderItem) {
     return XfR.ok(purchaseOrderItemServiceImpl.save(purchaseOrderItem));
  }

  /**
   * 修改-传入修改后的全部数据采购订单明细信息
   * @param purchaseOrderItem 采购订单明细信息
   * @return XfR
   */
  @PutMapping("/purchaseorderitems/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrderItem purchaseOrderItem,@PathVariable Long id) {
      purchaseOrderItem.setId(id);
      return XfR.ok(purchaseOrderItemServiceImpl.updateById(purchaseOrderItem));
  }

  /**
   * 修改-传入修改的数据采购订单明细信息
   * @param purchaseOrderItem 采购订单明细信息
   * @return XfR
   */
  @PatchMapping("/purchaseorderitems/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrderItem purchaseOrderItem,@PathVariable Long id) {
      PurchaseOrderItem uppurchaseOrderItem = purchaseOrderItemServiceImpl.getById(id);
      if(uppurchaseOrderItem != null){
        uppurchaseOrderItem = ObjectCopyUtils.copyProperties(purchaseOrderItem,uppurchaseOrderItem,true);
      }
      return XfR.ok(purchaseOrderItemServiceImpl.updateById(uppurchaseOrderItem));
  }

  /**
   * 通过id删除采购订单明细信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorderitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderItemServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorderitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order_item");
     params.put("request", condition);

     return XfR.ok(purchaseOrderItemServiceImpl.querys(params));
  }

}
