package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.GoodsReceiptInit;
import com.xforceplus.ultraman.app.jctke.service.IGoodsReceiptInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 收货单原始数据前端控制器
 *
 * @author ultraman
 * @date 2022-05-12
 */
@RestController
public class GoodsReceiptInitController {

  @Autowired
  private IGoodsReceiptInitService goodsReceiptInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceiptInit 收货单原始数据
   * @return
   */
  @GetMapping("/goodsreceiptinits" )
  public XfR getGoodsReceiptInits(XfPage page, GoodsReceiptInit goodsReceiptInit) {
    return XfR.ok(goodsReceiptInitServiceImpl.page(page, Wrappers.query(goodsReceiptInit)));
  }

  /**
   * 通过id查询收货单原始数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceiptinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptInitServiceImpl.getById(id));
  }

  /**
   * 新增收货单原始数据
   * @param goodsReceiptInit 收货单原始数据
   * @return XfR
   */
  @PostMapping("/goodsreceiptinits")
  public XfR save(@RequestBody GoodsReceiptInit goodsReceiptInit) {
     return XfR.ok(goodsReceiptInitServiceImpl.save(goodsReceiptInit));
  }

  /**
   * 修改-传入修改后的全部数据收货单原始数据
   * @param goodsReceiptInit 收货单原始数据
   * @return XfR
   */
  @PutMapping("/goodsreceiptinits/{id}")
  public XfR putUpdate(@RequestBody GoodsReceiptInit goodsReceiptInit,@PathVariable Long id) {
      goodsReceiptInit.setId(id);
      return XfR.ok(goodsReceiptInitServiceImpl.updateById(goodsReceiptInit));
  }

  /**
   * 修改-传入修改的数据收货单原始数据
   * @param goodsReceiptInit 收货单原始数据
   * @return XfR
   */
  @PatchMapping("/goodsreceiptinits/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceiptInit goodsReceiptInit,@PathVariable Long id) {
      GoodsReceiptInit upgoodsReceiptInit = goodsReceiptInitServiceImpl.getById(id);
      if(upgoodsReceiptInit != null){
        upgoodsReceiptInit = ObjectCopyUtils.copyProperties(goodsReceiptInit,upgoodsReceiptInit,true);
      }
      return XfR.ok(goodsReceiptInitServiceImpl.updateById(upgoodsReceiptInit));
  }

  /**
   * 通过id删除收货单原始数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceiptinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiptInitServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceiptinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_receipt_init");
     params.put("request", condition);

     return XfR.ok(goodsReceiptInitServiceImpl.querys(params));
  }

}
