package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AdvanceChargeInterface;
import com.xforceplus.ultraman.app.jctke.service.IAdvanceChargeInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-01
 */
@RestController
public class AdvanceChargeInterfaceController {

  @Autowired
  private IAdvanceChargeInterfaceService advanceChargeInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param advanceChargeInterface ${table.comment}
   * @return
   */
  @GetMapping("/advancechargeinterfaces" )
  public XfR getAdvanceChargeInterfaces(XfPage page, AdvanceChargeInterface advanceChargeInterface) {
    return XfR.ok(advanceChargeInterfaceServiceImpl.page(page, Wrappers.query(advanceChargeInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/advancechargeinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(advanceChargeInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param advanceChargeInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/advancechargeinterfaces")
  public XfR save(@RequestBody AdvanceChargeInterface advanceChargeInterface) {
     return XfR.ok(advanceChargeInterfaceServiceImpl.save(advanceChargeInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param advanceChargeInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/advancechargeinterfaces/{id}")
  public XfR putUpdate(@RequestBody AdvanceChargeInterface advanceChargeInterface,@PathVariable Long id) {
      advanceChargeInterface.setId(id);
      return XfR.ok(advanceChargeInterfaceServiceImpl.updateById(advanceChargeInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param advanceChargeInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/advancechargeinterfaces/{id}")
  public XfR patchUpdate(@RequestBody AdvanceChargeInterface advanceChargeInterface,@PathVariable Long id) {
      AdvanceChargeInterface upadvanceChargeInterface = advanceChargeInterfaceServiceImpl.getById(id);
      if(upadvanceChargeInterface != null){
        upadvanceChargeInterface = ObjectCopyUtils.copyProperties(advanceChargeInterface,upadvanceChargeInterface,true);
      }
      return XfR.ok(advanceChargeInterfaceServiceImpl.updateById(upadvanceChargeInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/advancechargeinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(advanceChargeInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/advancechargeinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "advance_charge_interface");
     params.put("request", condition);

     return XfR.ok(advanceChargeInterfaceServiceImpl.querys(params));
  }

}
