package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentFeeReportInit;
import com.xforceplus.ultraman.app.jctke.service.IAgentFeeReportInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-13
 */
@RestController
public class AgentFeeReportInitController {

  @Autowired
  private IAgentFeeReportInitService agentFeeReportInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentFeeReportInit ${table.comment}
   * @return
   */
  @GetMapping("/agentfeereportinits" )
  public XfR getAgentFeeReportInits(XfPage page, AgentFeeReportInit agentFeeReportInit) {
    return XfR.ok(agentFeeReportInitServiceImpl.page(page, Wrappers.query(agentFeeReportInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentfeereportinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param agentFeeReportInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/agentfeereportinits")
  public XfR save(@RequestBody AgentFeeReportInit agentFeeReportInit) {
     return XfR.ok(agentFeeReportInitServiceImpl.save(agentFeeReportInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param agentFeeReportInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/agentfeereportinits/{id}")
  public XfR putUpdate(@RequestBody AgentFeeReportInit agentFeeReportInit,@PathVariable Long id) {
      agentFeeReportInit.setId(id);
      return XfR.ok(agentFeeReportInitServiceImpl.updateById(agentFeeReportInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param agentFeeReportInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/agentfeereportinits/{id}")
  public XfR patchUpdate(@RequestBody AgentFeeReportInit agentFeeReportInit,@PathVariable Long id) {
      AgentFeeReportInit upagentFeeReportInit = agentFeeReportInitServiceImpl.getById(id);
      if(upagentFeeReportInit != null){
        upagentFeeReportInit = ObjectCopyUtils.copyProperties(agentFeeReportInit,upagentFeeReportInit,true);
      }
      return XfR.ok(agentFeeReportInitServiceImpl.updateById(upagentFeeReportInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentfeereportinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportInitServiceImpl.removeById(id));
  }

  @PostMapping("/agentfeereportinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_fee_report_init");
     params.put("request", condition);

     return XfR.ok(agentFeeReportInitServiceImpl.querys(params));
  }

}
