package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PoAndPaymentManageldRelation;
import com.xforceplus.ultraman.app.jctke.service.IPoAndPaymentManageldRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 付款管理与采购单关系表前端控制器
 *
 * @author ultraman
 * @date 2022-06-18
 */
@RestController
public class PoAndPaymentManageldRelationController {

  @Autowired
  private IPoAndPaymentManageldRelationService poAndPaymentManageldRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return
   */
  @GetMapping("/poandpaymentmanageldrelations" )
  public XfR getPoAndPaymentManageldRelations(XfPage page, PoAndPaymentManageldRelation poAndPaymentManageldRelation) {
    return XfR.ok(poAndPaymentManageldRelationServiceImpl.page(page, Wrappers.query(poAndPaymentManageldRelation)));
  }

  /**
   * 通过id查询付款管理与采购单关系表
   * @param  id
   * @return XfR
   */
  @GetMapping("/poandpaymentmanageldrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(poAndPaymentManageldRelationServiceImpl.getById(id));
  }

  /**
   * 新增付款管理与采购单关系表
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return XfR
   */
  @PostMapping("/poandpaymentmanageldrelations")
  public XfR save(@RequestBody PoAndPaymentManageldRelation poAndPaymentManageldRelation) {
     return XfR.ok(poAndPaymentManageldRelationServiceImpl.save(poAndPaymentManageldRelation));
  }

  /**
   * 修改-传入修改后的全部数据付款管理与采购单关系表
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return XfR
   */
  @PutMapping("/poandpaymentmanageldrelations/{id}")
  public XfR putUpdate(@RequestBody PoAndPaymentManageldRelation poAndPaymentManageldRelation,@PathVariable Long id) {
      poAndPaymentManageldRelation.setId(id);
      return XfR.ok(poAndPaymentManageldRelationServiceImpl.updateById(poAndPaymentManageldRelation));
  }

  /**
   * 修改-传入修改的数据付款管理与采购单关系表
   * @param poAndPaymentManageldRelation 付款管理与采购单关系表
   * @return XfR
   */
  @PatchMapping("/poandpaymentmanageldrelations/{id}")
  public XfR patchUpdate(@RequestBody PoAndPaymentManageldRelation poAndPaymentManageldRelation,@PathVariable Long id) {
      PoAndPaymentManageldRelation uppoAndPaymentManageldRelation = poAndPaymentManageldRelationServiceImpl.getById(id);
      if(uppoAndPaymentManageldRelation != null){
        uppoAndPaymentManageldRelation = ObjectCopyUtils.copyProperties(poAndPaymentManageldRelation,uppoAndPaymentManageldRelation,true);
      }
      return XfR.ok(poAndPaymentManageldRelationServiceImpl.updateById(uppoAndPaymentManageldRelation));
  }

  /**
   * 通过id删除付款管理与采购单关系表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/poandpaymentmanageldrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(poAndPaymentManageldRelationServiceImpl.removeById(id));
  }

  @PostMapping("/poandpaymentmanageldrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "po_and_payment_manageld_relation");
     params.put("request", condition);

     return XfR.ok(poAndPaymentManageldRelationServiceImpl.querys(params));
  }

}
