package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.SubeiAmountApproval;
import com.xforceplus.ultraman.app.jctke.service.ISubeiAmountApprovalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-19
 */
@RestController
public class SubeiAmountApprovalController {

  @Autowired
  private ISubeiAmountApprovalService subeiAmountApprovalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param subeiAmountApproval ${table.comment}
   * @return
   */
  @GetMapping("/subeiamountapprovals" )
  public XfR getSubeiAmountApprovals(XfPage page, SubeiAmountApproval subeiAmountApproval) {
    return XfR.ok(subeiAmountApprovalServiceImpl.page(page, Wrappers.query(subeiAmountApproval)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/subeiamountapprovals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(subeiAmountApprovalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param subeiAmountApproval ${table.comment}
   * @return XfR
   */
  @PostMapping("/subeiamountapprovals")
  public XfR save(@RequestBody SubeiAmountApproval subeiAmountApproval) {
     return XfR.ok(subeiAmountApprovalServiceImpl.save(subeiAmountApproval));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param subeiAmountApproval ${table.comment}
   * @return XfR
   */
  @PutMapping("/subeiamountapprovals/{id}")
  public XfR putUpdate(@RequestBody SubeiAmountApproval subeiAmountApproval,@PathVariable Long id) {
      subeiAmountApproval.setId(id);
      return XfR.ok(subeiAmountApprovalServiceImpl.updateById(subeiAmountApproval));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param subeiAmountApproval ${table.comment}
   * @return XfR
   */
  @PatchMapping("/subeiamountapprovals/{id}")
  public XfR patchUpdate(@RequestBody SubeiAmountApproval subeiAmountApproval,@PathVariable Long id) {
      SubeiAmountApproval upsubeiAmountApproval = subeiAmountApprovalServiceImpl.getById(id);
      if(upsubeiAmountApproval != null){
        upsubeiAmountApproval = ObjectCopyUtils.copyProperties(subeiAmountApproval,upsubeiAmountApproval,true);
      }
      return XfR.ok(subeiAmountApprovalServiceImpl.updateById(upsubeiAmountApproval));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/subeiamountapprovals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(subeiAmountApprovalServiceImpl.removeById(id));
  }

  @PostMapping("/subeiamountapprovals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "subei_amount_approval");
     params.put("request", condition);

     return XfR.ok(subeiAmountApprovalServiceImpl.querys(params));
  }

}
