package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.SellerInfo;
import com.xforceplus.ultraman.app.jctke.service.ISellerInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-20
 */
@RestController
public class SellerInfoController {

  @Autowired
  private ISellerInfoService sellerInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInfo ${table.comment}
   * @return
   */
  @GetMapping("/sellerinfos" )
  public XfR getSellerInfos(XfPage page, SellerInfo sellerInfo) {
    return XfR.ok(sellerInfoServiceImpl.page(page, Wrappers.query(sellerInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinfos")
  public XfR save(@RequestBody SellerInfo sellerInfo) {
     return XfR.ok(sellerInfoServiceImpl.save(sellerInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinfos/{id}")
  public XfR putUpdate(@RequestBody SellerInfo sellerInfo,@PathVariable Long id) {
      sellerInfo.setId(id);
      return XfR.ok(sellerInfoServiceImpl.updateById(sellerInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinfos/{id}")
  public XfR patchUpdate(@RequestBody SellerInfo sellerInfo,@PathVariable Long id) {
      SellerInfo upsellerInfo = sellerInfoServiceImpl.getById(id);
      if(upsellerInfo != null){
        upsellerInfo = ObjectCopyUtils.copyProperties(sellerInfo,upsellerInfo,true);
      }
      return XfR.ok(sellerInfoServiceImpl.updateById(upsellerInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInfoServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_info");
     params.put("request", condition);

     return XfR.ok(sellerInfoServiceImpl.querys(params));
  }

}
