package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ArPowerBi;
import com.xforceplus.ultraman.app.jctke.service.IArPowerBiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-23
 */
@RestController
public class ArPowerBiController {

  @Autowired
  private IArPowerBiService arPowerBiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param arPowerBi ${table.comment}
   * @return
   */
  @GetMapping("/arpowerbis" )
  public XfR getArPowerBis(XfPage page, ArPowerBi arPowerBi) {
    return XfR.ok(arPowerBiServiceImpl.page(page, Wrappers.query(arPowerBi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/arpowerbis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(arPowerBiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param arPowerBi ${table.comment}
   * @return XfR
   */
  @PostMapping("/arpowerbis")
  public XfR save(@RequestBody ArPowerBi arPowerBi) {
     return XfR.ok(arPowerBiServiceImpl.save(arPowerBi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param arPowerBi ${table.comment}
   * @return XfR
   */
  @PutMapping("/arpowerbis/{id}")
  public XfR putUpdate(@RequestBody ArPowerBi arPowerBi,@PathVariable Long id) {
      arPowerBi.setId(id);
      return XfR.ok(arPowerBiServiceImpl.updateById(arPowerBi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param arPowerBi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/arpowerbis/{id}")
  public XfR patchUpdate(@RequestBody ArPowerBi arPowerBi,@PathVariable Long id) {
      ArPowerBi uparPowerBi = arPowerBiServiceImpl.getById(id);
      if(uparPowerBi != null){
        uparPowerBi = ObjectCopyUtils.copyProperties(arPowerBi,uparPowerBi,true);
      }
      return XfR.ok(arPowerBiServiceImpl.updateById(uparPowerBi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/arpowerbis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(arPowerBiServiceImpl.removeById(id));
  }

  @PostMapping("/arpowerbis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ar_power_bi");
     params.put("request", condition);

     return XfR.ok(arPowerBiServiceImpl.querys(params));
  }

}
