package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PayInvoNoBillRelation;
import com.xforceplus.ultraman.app.jctke.service.IPayInvoNoBillRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-23
 */
@RestController
public class PayInvoNoBillRelationController {

  @Autowired
  private IPayInvoNoBillRelationService payInvoNoBillRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payInvoNoBillRelation ${table.comment}
   * @return
   */
  @GetMapping("/payinvonobillrelations" )
  public XfR getPayInvoNoBillRelations(XfPage page, PayInvoNoBillRelation payInvoNoBillRelation) {
    return XfR.ok(payInvoNoBillRelationServiceImpl.page(page, Wrappers.query(payInvoNoBillRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/payinvonobillrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payInvoNoBillRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param payInvoNoBillRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/payinvonobillrelations")
  public XfR save(@RequestBody PayInvoNoBillRelation payInvoNoBillRelation) {
     return XfR.ok(payInvoNoBillRelationServiceImpl.save(payInvoNoBillRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param payInvoNoBillRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/payinvonobillrelations/{id}")
  public XfR putUpdate(@RequestBody PayInvoNoBillRelation payInvoNoBillRelation,@PathVariable Long id) {
      payInvoNoBillRelation.setId(id);
      return XfR.ok(payInvoNoBillRelationServiceImpl.updateById(payInvoNoBillRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param payInvoNoBillRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/payinvonobillrelations/{id}")
  public XfR patchUpdate(@RequestBody PayInvoNoBillRelation payInvoNoBillRelation,@PathVariable Long id) {
      PayInvoNoBillRelation uppayInvoNoBillRelation = payInvoNoBillRelationServiceImpl.getById(id);
      if(uppayInvoNoBillRelation != null){
        uppayInvoNoBillRelation = ObjectCopyUtils.copyProperties(payInvoNoBillRelation,uppayInvoNoBillRelation,true);
      }
      return XfR.ok(payInvoNoBillRelationServiceImpl.updateById(uppayInvoNoBillRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/payinvonobillrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payInvoNoBillRelationServiceImpl.removeById(id));
  }

  @PostMapping("/payinvonobillrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_invo_no_bill_relation");
     params.put("request", condition);

     return XfR.ok(payInvoNoBillRelationServiceImpl.querys(params));
  }

}
