package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentPaymentTermInit;
import com.xforceplus.ultraman.app.jctke.service.IAgentPaymentTermInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class AgentPaymentTermInitController {

  @Autowired
  private IAgentPaymentTermInitService agentPaymentTermInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentPaymentTermInit ${table.comment}
   * @return
   */
  @GetMapping("/agentpaymentterminits" )
  public XfR getAgentPaymentTermInits(XfPage page, AgentPaymentTermInit agentPaymentTermInit) {
    return XfR.ok(agentPaymentTermInitServiceImpl.page(page, Wrappers.query(agentPaymentTermInit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentpaymentterminits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermInitServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param agentPaymentTermInit ${table.comment}
   * @return XfR
   */
  @PostMapping("/agentpaymentterminits")
  public XfR save(@RequestBody AgentPaymentTermInit agentPaymentTermInit) {
     return XfR.ok(agentPaymentTermInitServiceImpl.save(agentPaymentTermInit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param agentPaymentTermInit ${table.comment}
   * @return XfR
   */
  @PutMapping("/agentpaymentterminits/{id}")
  public XfR putUpdate(@RequestBody AgentPaymentTermInit agentPaymentTermInit,@PathVariable Long id) {
      agentPaymentTermInit.setId(id);
      return XfR.ok(agentPaymentTermInitServiceImpl.updateById(agentPaymentTermInit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param agentPaymentTermInit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/agentpaymentterminits/{id}")
  public XfR patchUpdate(@RequestBody AgentPaymentTermInit agentPaymentTermInit,@PathVariable Long id) {
      AgentPaymentTermInit upagentPaymentTermInit = agentPaymentTermInitServiceImpl.getById(id);
      if(upagentPaymentTermInit != null){
        upagentPaymentTermInit = ObjectCopyUtils.copyProperties(agentPaymentTermInit,upagentPaymentTermInit,true);
      }
      return XfR.ok(agentPaymentTermInitServiceImpl.updateById(upagentPaymentTermInit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentpaymentterminits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermInitServiceImpl.removeById(id));
  }

  @PostMapping("/agentpaymentterminits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_payment_term_init");
     params.put("request", condition);

     return XfR.ok(agentPaymentTermInitServiceImpl.querys(params));
  }

}
