package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.PoImprest;
import com.xforceplus.ultraman.app.jctke.service.IPoImprestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-06-30
 */
@RestController
public class PoImprestController {

  @Autowired
  private IPoImprestService poImprestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param poImprest 
   * @return
   */
  @GetMapping("/poimprests" )
  public XfR getPoImprests(XfPage page, PoImprest poImprest) {
    return XfR.ok(poImprestServiceImpl.page(page, Wrappers.query(poImprest)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/poimprests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(poImprestServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param poImprest 
   * @return XfR
   */
  @PostMapping("/poimprests")
  public XfR save(@RequestBody PoImprest poImprest) {
     return XfR.ok(poImprestServiceImpl.save(poImprest));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param poImprest 
   * @return XfR
   */
  @PutMapping("/poimprests/{id}")
  public XfR putUpdate(@RequestBody PoImprest poImprest,@PathVariable Long id) {
      poImprest.setId(id);
      return XfR.ok(poImprestServiceImpl.updateById(poImprest));
  }

  /**
   * 修改-传入修改的数据
   * @param poImprest 
   * @return XfR
   */
  @PatchMapping("/poimprests/{id}")
  public XfR patchUpdate(@RequestBody PoImprest poImprest,@PathVariable Long id) {
      PoImprest uppoImprest = poImprestServiceImpl.getById(id);
      if(uppoImprest != null){
        uppoImprest = ObjectCopyUtils.copyProperties(poImprest,uppoImprest,true);
      }
      return XfR.ok(poImprestServiceImpl.updateById(uppoImprest));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/poimprests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(poImprestServiceImpl.removeById(id));
  }

  @PostMapping("/poimprests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "po_imprest");
     params.put("request", condition);

     return XfR.ok(poImprestServiceImpl.querys(params));
  }

}
