package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentPaymentTerm;
import com.xforceplus.ultraman.app.jctke.service.IAgentPaymentTermService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-04
 */
@RestController
public class AgentPaymentTermController {

  @Autowired
  private IAgentPaymentTermService agentPaymentTermServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentPaymentTerm ${table.comment}
   * @return
   */
  @GetMapping("/agentpaymentterms" )
  public XfR getAgentPaymentTerms(XfPage page, AgentPaymentTerm agentPaymentTerm) {
    return XfR.ok(agentPaymentTermServiceImpl.page(page, Wrappers.query(agentPaymentTerm)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentpaymentterms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param agentPaymentTerm ${table.comment}
   * @return XfR
   */
  @PostMapping("/agentpaymentterms")
  public XfR save(@RequestBody AgentPaymentTerm agentPaymentTerm) {
     return XfR.ok(agentPaymentTermServiceImpl.save(agentPaymentTerm));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param agentPaymentTerm ${table.comment}
   * @return XfR
   */
  @PutMapping("/agentpaymentterms/{id}")
  public XfR putUpdate(@RequestBody AgentPaymentTerm agentPaymentTerm,@PathVariable Long id) {
      agentPaymentTerm.setId(id);
      return XfR.ok(agentPaymentTermServiceImpl.updateById(agentPaymentTerm));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param agentPaymentTerm ${table.comment}
   * @return XfR
   */
  @PatchMapping("/agentpaymentterms/{id}")
  public XfR patchUpdate(@RequestBody AgentPaymentTerm agentPaymentTerm,@PathVariable Long id) {
      AgentPaymentTerm upagentPaymentTerm = agentPaymentTermServiceImpl.getById(id);
      if(upagentPaymentTerm != null){
        upagentPaymentTerm = ObjectCopyUtils.copyProperties(agentPaymentTerm,upagentPaymentTerm,true);
      }
      return XfR.ok(agentPaymentTermServiceImpl.updateById(upagentPaymentTerm));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentpaymentterms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentPaymentTermServiceImpl.removeById(id));
  }

  @PostMapping("/agentpaymentterms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_payment_term");
     params.put("request", condition);

     return XfR.ok(agentPaymentTermServiceImpl.querys(params));
  }

}
