package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentFeeReport;
import com.xforceplus.ultraman.app.jctke.service.IAgentFeeReportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-18
 */
@RestController
public class AgentFeeReportController {

  @Autowired
  private IAgentFeeReportService agentFeeReportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentFeeReport ${table.comment}
   * @return
   */
  @GetMapping("/agentfeereports" )
  public XfR getAgentFeeReports(XfPage page, AgentFeeReport agentFeeReport) {
    return XfR.ok(agentFeeReportServiceImpl.page(page, Wrappers.query(agentFeeReport)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentfeereports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param agentFeeReport ${table.comment}
   * @return XfR
   */
  @PostMapping("/agentfeereports")
  public XfR save(@RequestBody AgentFeeReport agentFeeReport) {
     return XfR.ok(agentFeeReportServiceImpl.save(agentFeeReport));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param agentFeeReport ${table.comment}
   * @return XfR
   */
  @PutMapping("/agentfeereports/{id}")
  public XfR putUpdate(@RequestBody AgentFeeReport agentFeeReport,@PathVariable Long id) {
      agentFeeReport.setId(id);
      return XfR.ok(agentFeeReportServiceImpl.updateById(agentFeeReport));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param agentFeeReport ${table.comment}
   * @return XfR
   */
  @PatchMapping("/agentfeereports/{id}")
  public XfR patchUpdate(@RequestBody AgentFeeReport agentFeeReport,@PathVariable Long id) {
      AgentFeeReport upagentFeeReport = agentFeeReportServiceImpl.getById(id);
      if(upagentFeeReport != null){
        upagentFeeReport = ObjectCopyUtils.copyProperties(agentFeeReport,upagentFeeReport,true);
      }
      return XfR.ok(agentFeeReportServiceImpl.updateById(upagentFeeReport));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentfeereports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportServiceImpl.removeById(id));
  }

  @PostMapping("/agentfeereports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_fee_report");
     params.put("request", condition);

     return XfR.ok(agentFeeReportServiceImpl.querys(params));
  }

}
