package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.RpaTask;
import com.xforceplus.ultraman.app.jctke.service.IRpaTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-18
 */
@RestController
public class RpaTaskController {

  @Autowired
  private IRpaTaskService rpaTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rpaTask ${table.comment}
   * @return
   */
  @GetMapping("/rpatasks" )
  public XfR getRpaTasks(XfPage page, RpaTask rpaTask) {
    return XfR.ok(rpaTaskServiceImpl.page(page, Wrappers.query(rpaTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rpatasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rpaTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rpaTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/rpatasks")
  public XfR save(@RequestBody RpaTask rpaTask) {
     return XfR.ok(rpaTaskServiceImpl.save(rpaTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rpaTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/rpatasks/{id}")
  public XfR putUpdate(@RequestBody RpaTask rpaTask,@PathVariable Long id) {
      rpaTask.setId(id);
      return XfR.ok(rpaTaskServiceImpl.updateById(rpaTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rpaTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rpatasks/{id}")
  public XfR patchUpdate(@RequestBody RpaTask rpaTask,@PathVariable Long id) {
      RpaTask uprpaTask = rpaTaskServiceImpl.getById(id);
      if(uprpaTask != null){
        uprpaTask = ObjectCopyUtils.copyProperties(rpaTask,uprpaTask,true);
      }
      return XfR.ok(rpaTaskServiceImpl.updateById(uprpaTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rpatasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rpaTaskServiceImpl.removeById(id));
  }

  @PostMapping("/rpatasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rpa_task");
     params.put("request", condition);

     return XfR.ok(rpaTaskServiceImpl.querys(params));
  }

}
