package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.SellerInit;
import com.xforceplus.ultraman.app.jctke.service.ISellerInitService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 供应商原始数据前端控制器
 *
 * @author ultraman
 * @date 2022-09-01
 */
@RestController
public class SellerInitController {

  @Autowired
  private ISellerInitService sellerInitServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInit 供应商原始数据
   * @return
   */
  @GetMapping("/sellerinits" )
  public XfR getSellerInits(XfPage page, SellerInit sellerInit) {
    return XfR.ok(sellerInitServiceImpl.page(page, Wrappers.query(sellerInit)));
  }

  /**
   * 通过id查询供应商原始数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInitServiceImpl.getById(id));
  }

  /**
   * 新增供应商原始数据
   * @param sellerInit 供应商原始数据
   * @return XfR
   */
  @PostMapping("/sellerinits")
  public XfR save(@RequestBody SellerInit sellerInit) {
     return XfR.ok(sellerInitServiceImpl.save(sellerInit));
  }

  /**
   * 修改-传入修改后的全部数据供应商原始数据
   * @param sellerInit 供应商原始数据
   * @return XfR
   */
  @PutMapping("/sellerinits/{id}")
  public XfR putUpdate(@RequestBody SellerInit sellerInit,@PathVariable Long id) {
      sellerInit.setId(id);
      return XfR.ok(sellerInitServiceImpl.updateById(sellerInit));
  }

  /**
   * 修改-传入修改的数据供应商原始数据
   * @param sellerInit 供应商原始数据
   * @return XfR
   */
  @PatchMapping("/sellerinits/{id}")
  public XfR patchUpdate(@RequestBody SellerInit sellerInit,@PathVariable Long id) {
      SellerInit upsellerInit = sellerInitServiceImpl.getById(id);
      if(upsellerInit != null){
        upsellerInit = ObjectCopyUtils.copyProperties(sellerInit,upsellerInit,true);
      }
      return XfR.ok(sellerInitServiceImpl.updateById(upsellerInit));
  }

  /**
   * 通过id删除供应商原始数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInitServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_init");
     params.put("request", condition);

     return XfR.ok(sellerInitServiceImpl.querys(params));
  }

}
