package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApplyId;
import com.xforceplus.ultraman.app.jctke.service.IApplyIdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 申请Id前端控制器
 *
 * @author ultraman
 * @date 2022-09-13
 */
@RestController
public class ApplyIdController {

  @Autowired
  private IApplyIdService applyIdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param applyId 申请Id
   * @return
   */
  @GetMapping("/applyids" )
  public XfR getApplyIds(XfPage page, ApplyId applyId) {
    return XfR.ok(applyIdServiceImpl.page(page, Wrappers.query(applyId)));
  }

  /**
   * 通过id查询申请Id
   * @param  id
   * @return XfR
   */
  @GetMapping("/applyids/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(applyIdServiceImpl.getById(id));
  }

  /**
   * 新增申请Id
   * @param applyId 申请Id
   * @return XfR
   */
  @PostMapping("/applyids")
  public XfR save(@RequestBody ApplyId applyId) {
     return XfR.ok(applyIdServiceImpl.save(applyId));
  }

  /**
   * 修改-传入修改后的全部数据申请Id
   * @param applyId 申请Id
   * @return XfR
   */
  @PutMapping("/applyids/{id}")
  public XfR putUpdate(@RequestBody ApplyId applyId,@PathVariable Long id) {
      applyId.setId(id);
      return XfR.ok(applyIdServiceImpl.updateById(applyId));
  }

  /**
   * 修改-传入修改的数据申请Id
   * @param applyId 申请Id
   * @return XfR
   */
  @PatchMapping("/applyids/{id}")
  public XfR patchUpdate(@RequestBody ApplyId applyId,@PathVariable Long id) {
      ApplyId upapplyId = applyIdServiceImpl.getById(id);
      if(upapplyId != null){
        upapplyId = ObjectCopyUtils.copyProperties(applyId,upapplyId,true);
      }
      return XfR.ok(applyIdServiceImpl.updateById(upapplyId));
  }

  /**
   * 通过id删除申请Id
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applyids/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(applyIdServiceImpl.removeById(id));
  }

  @PostMapping("/applyids/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "apply_id");
     params.put("request", condition);

     return XfR.ok(applyIdServiceImpl.querys(params));
  }

}
