package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.SellerInitFailedHistory;
import com.xforceplus.ultraman.app.jctke.service.ISellerInitFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-13
 */
@RestController
public class SellerInitFailedHistoryController {

  @Autowired
  private ISellerInitFailedHistoryService sellerInitFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInitFailedHistory ${table.comment}
   * @return
   */
  @GetMapping("/sellerinitfailedhistorys" )
  public XfR getSellerInitFailedHistorys(XfPage page, SellerInitFailedHistory sellerInitFailedHistory) {
    return XfR.ok(sellerInitFailedHistoryServiceImpl.page(page, Wrappers.query(sellerInitFailedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinitfailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInitFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinitfailedhistorys")
  public XfR save(@RequestBody SellerInitFailedHistory sellerInitFailedHistory) {
     return XfR.ok(sellerInitFailedHistoryServiceImpl.save(sellerInitFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinitfailedhistorys/{id}")
  public XfR putUpdate(@RequestBody SellerInitFailedHistory sellerInitFailedHistory,@PathVariable Long id) {
      sellerInitFailedHistory.setId(id);
      return XfR.ok(sellerInitFailedHistoryServiceImpl.updateById(sellerInitFailedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInitFailedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinitfailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody SellerInitFailedHistory sellerInitFailedHistory,@PathVariable Long id) {
      SellerInitFailedHistory upsellerInitFailedHistory = sellerInitFailedHistoryServiceImpl.getById(id);
      if(upsellerInitFailedHistory != null){
        upsellerInitFailedHistory = ObjectCopyUtils.copyProperties(sellerInitFailedHistory,upsellerInitFailedHistory,true);
      }
      return XfR.ok(sellerInitFailedHistoryServiceImpl.updateById(upsellerInitFailedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinitfailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInitFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinitfailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_init_failed_history");
     params.put("request", condition);

     return XfR.ok(sellerInitFailedHistoryServiceImpl.querys(params));
  }

}
