package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AgentFeeReportInitFailedHistory;
import com.xforceplus.ultraman.app.jctke.service.IAgentFeeReportInitFailedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-10-09
 */
@RestController
public class AgentFeeReportInitFailedHistoryController {

  @Autowired
  private IAgentFeeReportInitFailedHistoryService agentFeeReportInitFailedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param agentFeeReportInitFailedHistory 
   * @return
   */
  @GetMapping("/agentfeereportinitfailedhistorys" )
  public XfR getAgentFeeReportInitFailedHistorys(XfPage page, AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory) {
    return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.page(page, Wrappers.query(agentFeeReportInitFailedHistory)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/agentfeereportinitfailedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param agentFeeReportInitFailedHistory 
   * @return XfR
   */
  @PostMapping("/agentfeereportinitfailedhistorys")
  public XfR save(@RequestBody AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory) {
     return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.save(agentFeeReportInitFailedHistory));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param agentFeeReportInitFailedHistory 
   * @return XfR
   */
  @PutMapping("/agentfeereportinitfailedhistorys/{id}")
  public XfR putUpdate(@RequestBody AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory,@PathVariable Long id) {
      agentFeeReportInitFailedHistory.setId(id);
      return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.updateById(agentFeeReportInitFailedHistory));
  }

  /**
   * 修改-传入修改的数据
   * @param agentFeeReportInitFailedHistory 
   * @return XfR
   */
  @PatchMapping("/agentfeereportinitfailedhistorys/{id}")
  public XfR patchUpdate(@RequestBody AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory,@PathVariable Long id) {
      AgentFeeReportInitFailedHistory upagentFeeReportInitFailedHistory = agentFeeReportInitFailedHistoryServiceImpl.getById(id);
      if(upagentFeeReportInitFailedHistory != null){
        upagentFeeReportInitFailedHistory = ObjectCopyUtils.copyProperties(agentFeeReportInitFailedHistory,upagentFeeReportInitFailedHistory,true);
      }
      return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.updateById(upagentFeeReportInitFailedHistory));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/agentfeereportinitfailedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/agentfeereportinitfailedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "agent_fee_report_init_failed_history");
     params.put("request", condition);

     return XfR.ok(agentFeeReportInitFailedHistoryServiceImpl.querys(params));
  }

}
