package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApprovalHistory;
import com.xforceplus.ultraman.app.jctke.service.IApprovalHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 原审批历史表前端控制器
 *
 * @author ultraman
 * @date 2022-10-09
 */
@RestController
public class ApprovalHistoryController {

  @Autowired
  private IApprovalHistoryService approvalHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param approvalHistory 原审批历史表
   * @return
   */
  @GetMapping("/approvalhistorys" )
  public XfR getApprovalHistorys(XfPage page, ApprovalHistory approvalHistory) {
    return XfR.ok(approvalHistoryServiceImpl.page(page, Wrappers.query(approvalHistory)));
  }

  /**
   * 通过id查询原审批历史表
   * @param  id
   * @return XfR
   */
  @GetMapping("/approvalhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(approvalHistoryServiceImpl.getById(id));
  }

  /**
   * 新增原审批历史表
   * @param approvalHistory 原审批历史表
   * @return XfR
   */
  @PostMapping("/approvalhistorys")
  public XfR save(@RequestBody ApprovalHistory approvalHistory) {
     return XfR.ok(approvalHistoryServiceImpl.save(approvalHistory));
  }

  /**
   * 修改-传入修改后的全部数据原审批历史表
   * @param approvalHistory 原审批历史表
   * @return XfR
   */
  @PutMapping("/approvalhistorys/{id}")
  public XfR putUpdate(@RequestBody ApprovalHistory approvalHistory,@PathVariable Long id) {
      approvalHistory.setId(id);
      return XfR.ok(approvalHistoryServiceImpl.updateById(approvalHistory));
  }

  /**
   * 修改-传入修改的数据原审批历史表
   * @param approvalHistory 原审批历史表
   * @return XfR
   */
  @PatchMapping("/approvalhistorys/{id}")
  public XfR patchUpdate(@RequestBody ApprovalHistory approvalHistory,@PathVariable Long id) {
      ApprovalHistory upapprovalHistory = approvalHistoryServiceImpl.getById(id);
      if(upapprovalHistory != null){
        upapprovalHistory = ObjectCopyUtils.copyProperties(approvalHistory,upapprovalHistory,true);
      }
      return XfR.ok(approvalHistoryServiceImpl.updateById(upapprovalHistory));
  }

  /**
   * 通过id删除原审批历史表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/approvalhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(approvalHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/approvalhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "approval_history");
     params.put("request", condition);

     return XfR.ok(approvalHistoryServiceImpl.querys(params));
  }

}
