package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.AccountsPayableInterface;
import com.xforceplus.ultraman.app.jctke.service.IAccountsPayableInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-11
 */
@RestController
public class AccountsPayableInterfaceController {

  @Autowired
  private IAccountsPayableInterfaceService accountsPayableInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountsPayableInterface ${table.comment}
   * @return
   */
  @GetMapping("/accountspayableinterfaces" )
  public XfR getAccountsPayableInterfaces(XfPage page, AccountsPayableInterface accountsPayableInterface) {
    return XfR.ok(accountsPayableInterfaceServiceImpl.page(page, Wrappers.query(accountsPayableInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountspayableinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountsPayableInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountsPayableInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountspayableinterfaces")
  public XfR save(@RequestBody AccountsPayableInterface accountsPayableInterface) {
     return XfR.ok(accountsPayableInterfaceServiceImpl.save(accountsPayableInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountsPayableInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountspayableinterfaces/{id}")
  public XfR putUpdate(@RequestBody AccountsPayableInterface accountsPayableInterface,@PathVariable Long id) {
      accountsPayableInterface.setId(id);
      return XfR.ok(accountsPayableInterfaceServiceImpl.updateById(accountsPayableInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountsPayableInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountspayableinterfaces/{id}")
  public XfR patchUpdate(@RequestBody AccountsPayableInterface accountsPayableInterface,@PathVariable Long id) {
      AccountsPayableInterface upaccountsPayableInterface = accountsPayableInterfaceServiceImpl.getById(id);
      if(upaccountsPayableInterface != null){
        upaccountsPayableInterface = ObjectCopyUtils.copyProperties(accountsPayableInterface,upaccountsPayableInterface,true);
      }
      return XfR.ok(accountsPayableInterfaceServiceImpl.updateById(upaccountsPayableInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountspayableinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountsPayableInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/accountspayableinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "accounts_payable_interface");
     params.put("request", condition);

     return XfR.ok(accountsPayableInterfaceServiceImpl.querys(params));
  }

}
