package com.xforceplus.ultraman.app.jctke.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jctke.entity.ApprovalRules;
import com.xforceplus.ultraman.app.jctke.service.IApprovalRulesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 线上审批规则前端控制器
 *
 * @author ultraman
 * @date 2022-10-11
 */
@RestController
public class ApprovalRulesController {

  @Autowired
  private IApprovalRulesService approvalRulesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param approvalRules 线上审批规则
   * @return
   */
  @GetMapping("/approvalruless" )
  public XfR getApprovalRuless(XfPage page, ApprovalRules approvalRules) {
    return XfR.ok(approvalRulesServiceImpl.page(page, Wrappers.query(approvalRules)));
  }

  /**
   * 通过id查询线上审批规则
   * @param  id
   * @return XfR
   */
  @GetMapping("/approvalruless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(approvalRulesServiceImpl.getById(id));
  }

  /**
   * 新增线上审批规则
   * @param approvalRules 线上审批规则
   * @return XfR
   */
  @PostMapping("/approvalruless")
  public XfR save(@RequestBody ApprovalRules approvalRules) {
     return XfR.ok(approvalRulesServiceImpl.save(approvalRules));
  }

  /**
   * 修改-传入修改后的全部数据线上审批规则
   * @param approvalRules 线上审批规则
   * @return XfR
   */
  @PutMapping("/approvalruless/{id}")
  public XfR putUpdate(@RequestBody ApprovalRules approvalRules,@PathVariable Long id) {
      approvalRules.setId(id);
      return XfR.ok(approvalRulesServiceImpl.updateById(approvalRules));
  }

  /**
   * 修改-传入修改的数据线上审批规则
   * @param approvalRules 线上审批规则
   * @return XfR
   */
  @PatchMapping("/approvalruless/{id}")
  public XfR patchUpdate(@RequestBody ApprovalRules approvalRules,@PathVariable Long id) {
      ApprovalRules upapprovalRules = approvalRulesServiceImpl.getById(id);
      if(upapprovalRules != null){
        upapprovalRules = ObjectCopyUtils.copyProperties(approvalRules,upapprovalRules,true);
      }
      return XfR.ok(approvalRulesServiceImpl.updateById(upapprovalRules));
  }

  /**
   * 通过id删除线上审批规则
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/approvalruless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(approvalRulesServiceImpl.removeById(id));
  }

  @PostMapping("/approvalruless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "approval_rules");
     params.put("request", condition);

     return XfR.ok(approvalRulesServiceImpl.querys(params));
  }

}
